<?php

namespace App\Controllers;

class Orders extends BaseController
{
    protected $configModel;
    protected $mlModel;
    protected $ordenesModel;

    public function __construct()
    {
        $this->configModel = new \App\Models\ConfigModel();
        $this->mlModel = new \App\Models\MercadoLibreModel();
        $this->ordenesModel = new \App\Models\OrdenesModel();
    }

    public function index()
    {
        $data['ml_config'] = [
            'client_id' => $this->configModel->getConfig('ml_client_id'),
            'client_secret' => $this->configModel->getConfig('ml_client_secret'),
            'sync_active' => $this->configModel->getConfig('ml_sync_active')
        ];

        return view('home_orders', $data);
    }
    public function listar()
    {
        //$ordenes = $this->ordenesModel->getOrdenes();
        //return $this->response->setJSON($ordenes);

        if ($this->request->isAJAX()) {
            $start = $this->request->getGet('start') ?? 0;
            $length = $this->request->getGet('length') ?? 10;
            $search = $this->request->getGet('search')['value'] ?? '';
            $order = $this->request->getGet('order')[0] ?? null;
            $columns = ['NumeroD', 'FechaT', 'CodUsua', 'total_productos', 'CodSucu'];
            $orderColumn = $columns[$order['column'] ?? 0] ?? 'FechaT';
            $orderDir = $order['dir'] ?? 'DESC';
    
            $result = $this->ordenesModel->getOrdenes(
                $start, 
                $length, 
                $search,
                $orderColumn,
                $orderDir
            );
    
            return $this->response->setJSON([
                'draw' => $this->request->getGet('draw'),
                'recordsTotal' => $result['recordsTotal'],
                'recordsFiltered' => $result['recordsFiltered'],
                'data' => $result['data']
            ]);
        }
    }

    public function detalle($numeroD)
    {
        $data = $this->ordenesModel->getDetalleOrden($numeroD);
        return view('ordenes/detalle', $data);
    }

   
}