<?php

namespace App\Controllers;

class Home extends BaseController
{
    protected $bodegasModel;
    protected $productosModel;

    public function __construct()
    {
        $this->bodegasModel = new \App\Models\BodegasModel();
        $this->productosModel = new \App\Models\ProductosModel();
    }
    public function index(): string
    {
        $data['bodegas'] = $this->bodegasModel->getBodegas();
        return view('home_page', $data);
    }

    public function edit(): string
    {
        $prod_id = $this->request->getGet('id');
        $bodega = $this->request->getGet('bodega');
        // Obtener información del producto
        $producto = $this->productosModel->getProductoDetalle($prod_id, $bodega);

        $data = [
            'producto' => $producto,
            'bodegas' => $this->bodegasModel->getBodegas(),
            'prodid' => $prod_id,
            'bodega' => $bodega
        ];
        return view('home_edit', $data);
    }

    public function guardarEdicion()
    {
        if ($this->request->isAJAX()) {
            $prod_id = $this->request->getPost('prod_id');
            $bodega = $this->request->getPost('bodega');
            $nuevaPosicion = $this->request->getPost('posicion');

            try {
                $actualizado = $this->productosModel->actualizarUbicacion($prod_id, $bodega, $nuevaPosicion);

                return $this->response->setJSON([
                    'success' => true,
                    'message' => 'Ubicación actualizada correctamente'
                ]);
            } catch (\Exception $e) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => 'Error al actualizar la ubicación: ' . $e->getMessage()
                ])->setStatusCode(500);
            }
        }
    }

    public function buscar()
    {
        if ($this->request->isAJAX()) {
            $filtro = $this->request->getGet('filtro');
            $bodega = $this->request->getGet('bodega');

            $productos = $this->productosModel->buscarProductos($filtro, $bodega);

            return $this->response->setJSON($productos);
        }
    }
}

