<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="fn__title_holder">
    <h3>Configuración Jumpseller</h3>
</div>

<div class="fn__form">
    <div class="fn__form_item">
        <label>Login:</label>
        <input type="text" value="<?= esc($js_config['login']['valor'] ?? '') ?>" readonly>
    </div>
    <div class="fn__form_item">
        <label>Auth Token:</label>
        <input type="password" value="<?= esc($js_config['auth_token']['valor'] ?? '') ?>" readonly>
    </div>
    <div class="fn__form_item">
        <label>Estado de Sincronización:</label>
        <div class="toggle_switch">
            <input type="checkbox" id="syncToggle" <?= ($js_config['sync_active']['valor'] ?? '') ? 'checked' : '' ?>>
            <label for="syncToggle">Activar/Desactivar</label>
        </div>
    </div>
    <button type="button" id="syncNowBtn" class="techwave_fn_button">
        <span>Sincronizar Ahora</span>
    </button>
    <button type="button" id="listProductsBtn" class="techwave_fn_button">
        <span>Listar Productos</span>
    </button>
</div>

<div class="fn__title_holder mt-4">
    <h3>Productos Sincronizados</h3>
</div>
<div class="fn__table_wrap">
    <table id="productosTable" class="display">
        <thead>
            <tr>
                <th>Código</th>
                <th>Bod.</th>
                <th>Ubi.</th>
                <th>Precio</th>
                <th>Descripción</th>
                <th>Stock Actual</th>
                <th>Stock Jumps</th>
                <th>ID Jumpseller</th>
                <th>Última Sync</th>
                <th>Acciones</th>
                <th><input type="checkbox" id="select-all"></th>
            </tr>
        </thead>
        <tbody>
            <!-- Se llena vía AJAX -->
        </tbody>
    </table>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
function sincronizarProducto(codProd, jsID) {
    const isChecked = syncToggle.checked;
    console.log('CHECK TOGGLE', isChecked);
    
    if (isChecked) {
        Swal.fire({
            title: '¿Sincronizar producto?',
            text: `¿Desea sincronizar el producto ${jsID}?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, sincronizar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Mostrar loading
                Swal.fire({
                    title: 'Sincronizando...',
                    text: 'Por favor espere',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                $.ajax({
                    url: '<?= base_url('jumpseller/sincronizarProducto') ?>',
                    method: 'POST',
                    data: {
                        codProd: codProd,
                        js_id: jsID
                    },
                    success: function(response) {
                        console.log(response);
                        if (response.success) {
                            Swal.fire({
                                title: '¡Éxito!',
                                text: 'Producto ' + response.data.data.sku + ' JS ID ' +
                                    response.data.data.js_id +
                                    ' sincronizado correctamente. Stock: ' + response.data.data.new_stock,
                                icon: 'success'
                            });
                            $('#productosTable').DataTable().ajax.reload(null, false);
                        } else {
                            Swal.fire({
                                title: 'Error',
                                text: response.message,
                                icon: 'error'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            title: 'Error',
                            text: 'Error al sincronizar el producto',
                            icon: 'error'
                        });
                    }
                });
            }
        });
    } else {
        Swal.fire({
            title: 'Error',
            text: 'Activar la casilla de Sincronización para activar Jumpseller',
            icon: 'error'
        });
    }
}

function mostrarDetallesJS(producto) {
    if (producto.js_id) {
        Swal.fire({
            title: 'Información de Jumpseller',
            html: `
                <div class="text-left">
                    <p><strong>Nombre:</strong> ${producto.js_name || 'No disponible'}</p>
                    <p><strong>Precio:</strong> ${producto.js_price || 'No disponible'}</p>
                    <p><strong>Stock JS:</strong> ${producto.js_stock || 'No disponible'}</p>
                    <p><strong>Stock Local:</strong> ${producto.Existen || '0'}</p>
                    <p><strong>Estado:</strong> ${producto.js_status || 'No disponible'}</p>
                    <p><strong>SKU:</strong> ${producto.CodProd || 'No disponible'}</p>
                    <p><strong>ID JS:</strong> ${producto.js_id || 'No disponible'}</p>
                    ${producto.js_permalink ?
                        `<a href="${producto.js_permalink}" target="_blank" class="text-blue-500 hover:underline">
                            Ver en Jumpseller
                         </a>` : ''
                    }
                </div>
            `,
            width: '600px',
            customClass: {
                container: 'text-left'
            }
        });
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Producto no encontrado',
            text: 'No se encontró información en Jumpseller para este producto'
        });
    }
}

document.addEventListener('DOMContentLoaded', function() {
    const syncToggle = document.getElementById('syncToggle');
    const syncNowBtn = document.getElementById('syncNowBtn');
    const listProductsBtn = document.getElementById('listProductsBtn');

    $('#select-all').on('change', function() {
        const isChecked = $(this).is(':checked');
        console.log('Selected:', isChecked);
        $('.js-selector').prop('checked', isChecked);

        // Actualizar todos los elementos
        $('.js-selector').each(function() {
            const jsId = $(this).val();
            $.ajax({
                url: '<?= base_url('jumpseller/toggleProductSelection') ?>',
                method: 'POST',
                data: {
                    js_id: jsId,
                    selected: isChecked ? 1 : 0
                }
            });
        });
    });

    if ($.fn.DataTable.isDataTable('#productosTable')) {
        $('#productosTable').DataTable().destroy();
    }

    const table = $('#productosTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?= base_url('jumpseller/productos') ?>',
            type: 'GET'
        },
        columns: [{
                data: 'CodProd'
            },
            {
                data: 'CodUbic'
            },
            {
                data: 'Ubic'
            },
            {
                data: 'PrecioIVA'
            },
            {
                data: 'Descrip'
            },
            {
                data: 'Existen'
            },
            {
                data: 'js_stock'
            },
            {
                data: 'js_id'
            },
            {
                data: 'ultimo_sync'
            },
            {
                data: null,
                name: 'Acciones',
                orderable: false,
                render: function(data, type, row) {
                    return `
                    <div class="flex gap-2">
                        <button onclick="sincronizarProducto('${row.CodProd}', '${row.js_id}')" 
                                class="techwave_fn_button small">
                            <span>Sincronizar</span>
                        </button>
                        <button onclick="mostrarDetallesJS(${JSON.stringify(row).replace(/"/g, '&quot;')})"
                            class="techwave_fn_button small">
                            <i class="lucide-info"></i>
                        </button>
                    </div>`;
                }
            },
            {
                data: null,
                orderable: false,
                className: 'text-center',
                render: function(data, type, row) {
                    return `<input type="checkbox" class="js-selector" name="selected_products[]" 
                        value="${row.js_id}" ${row.selected == 1 ? 'checked' : ''}>`;
                }
            }
        ],
        pageLength: 25,
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json'
        },
        rowCallback: function(row, data) {
            console.log(data.Existen);
            if (data.Existen != data.js_stock) {
                $(row).addClass('stock-difference');
            }
        },
        initComplete: function() {
            $(document).on('change', '.js-selector', function(e) {
                e.preventDefault();
                const jsId = $(this).val();
                const selected = $(this).is(':checked') ? 1 : 0;

                console.log('JS ID:', jsId);
                console.log('Selected:', selected);

                $.ajax({
                    url: '<?= base_url('jumpseller/toggleProductSelection') ?>',
                    method: 'POST',
                    data: {
                        js_id: jsId,
                        selected: selected
                    },
                    success: function(response) {
                        if (response.success) {
                            console.log('Selección actualizada correctamente');
                        } else {
                            console.error('Error al actualizar selección:', response.message);
                            $(e.target).prop('checked', !selected);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error en la petición:', error);
                        $(e.target).prop('checked', !selected);
                    }
                });
            });
        }
    });

    // Toggle sincronización
    syncToggle.addEventListener('change', function() {
        $.ajax({
            url: '<?= base_url('jumpseller/toggleSync') ?>',
            method: 'POST',
            data: {
                estado: this.checked ? 1 : 0
            },
            success: function(response) {
                if (response.success) {
                    alert('Estado de sincronización actualizado');
                }
            }
        });
    });

    // Función para obtener productos seleccionados
    function getSelectedProducts() {
        const checkboxes = document.getElementsByName('selected_products[]');
        return Array.from(checkboxes)
            .filter(cb => cb.checked)
            .map(cb => cb.value);
    }

    // Función de sincronización masiva
    function sincronizarProductos(productos = []) {
        if (!syncToggle.checked) {
            Swal.fire({
                title: 'Error',
                text: 'Activar la casilla de Sincronización para activar Jumpseller',
                icon: 'error'
            });
            return;
        }

        Swal.fire({
            title: 'Sincronizando...',
            text: 'Por favor espere. Productos: ' + productos.length,
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: '<?= base_url('jumpseller/sincronizar') ?>',
            method: 'POST',
            data: {
                productos: productos
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: 'Productos sincronizados correctamente',
                        icon: 'success'
                    });
                    $('#productosTable').DataTable().ajax.reload(null, false);
                } else {
                    Swal.fire({
                        title: 'Error',
                        text: response.message,
                        icon: 'error'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    title: 'Error',
                    text: 'Error al sincronizar los productos',
                    icon: 'error'
                });
            }
        });
    }

    // Botón sincronizar ahora
    syncNowBtn.addEventListener('click', function() {
        const selectedProducts = getSelectedProducts();
        if (selectedProducts.length === 0) {
            Swal.fire({
                title: 'Error',
                text: 'Debe seleccionar al menos un producto para sincronizar',
                icon: 'warning'
            });
            return;
        }
        sincronizarProductos([]);
        //sincronizarProductos(selectedProducts);
    });

    // Botón listar productos
    listProductsBtn.addEventListener('click', function() {
        Swal.fire({
            title: 'Obteniendo productos...',
            text: 'Por favor espere',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: '<?= base_url('jumpseller/listarProductosJS') ?>',
            method: 'GET',
            success: function(response) {
                console.log(response);
                if (response.success) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: `Se obtuvieron ${response.total} productos de Jumpseller`,
                        icon: 'success'
                    });
                    // Recargar tabla para mostrar productos sincronizados
                    $('#productosTable').DataTable().ajax.reload(null, false);
                } else {
                    Swal.fire({
                        title: 'Error',
                        text: response.message,
                        icon: 'error'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    title: 'Error',
                    text: 'Error al obtener productos de Jumpseller',
                    icon: 'error'
                });
            }
        });
    });
});
</script>
<?= $this->endSection() ?>