<?php

namespace App\Controllers;

class Auth extends BaseController
{
    public function index()
    {
        // Si ya está logueado, redirigir al home
        if (session()->get('isLoggedIn')) {
            return redirect()->to('/home');
        }
        
        return redirect()->to('auth/login');
    }
    
    public function login()
    {
        // Si ya está logueado, redirigir al home
        if (session()->get('isLoggedIn')) {
            return redirect()->to('/');
        }
       
        
        return view('home_login');
    }

    // Método POST para procesar el formulario de login
    public function attemptLogin()
    {
        $rules = [
            'username' => 'required|min_length[3]',
            'password' => 'required|min_length[4]'
        ];
        
        if ($this->validate($rules)) {
            $model = new \App\Models\UserModel();
            $user = $model->where('username', $this->request->getVar('username'))->first();
            
            if ($user && password_verify($this->request->getVar('password'), $user['password'])) {
                $model = new \App\Models\UserModel();
                // Obtener los menús habilitados
                $userMenus = $model->getUserMenus($user['id']);

                $sessionData = [
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'userMenus' => $userMenus,
                    'isLoggedIn' => true
                ];
                
                session()->set($sessionData);
                return redirect()->to('/');
            } else {
                session()->setFlashdata('msg', 'Usuario o contraseña incorrectos');
                return redirect()->to('/auth/login');
            }
        } else {
            return view('home_login', ['validation' => $this->validator]);
        }
    }

    public function register()
    {
        // Si ya está logueado, redirigir al home
        if (session()->get('isLoggedIn')) {
            return redirect()->to('/');
        }
        
        
        
        return view('home_register');
    }
    
    // Método POST para procesar el formulario de registro
    public function attemptRegister()
    {
        $rules = [
            'username' => 'required|min_length[3]|is_unique[users.username]',
            'password' => 'required|min_length[4]',
            'confirm_password' => 'required|matches[password]'
        ];
        
        if ($this->validate($rules)) {
            $model = new \App\Models\UserModel();
            $data = [
                'username' => $this->request->getVar('username'),
                'password' => password_hash($this->request->getVar('password'), PASSWORD_DEFAULT),
                'menu_buscador' => $this->request->getVar('menu_buscador') ? 1 : 0,
                'menu_cotizaciones' => $this->request->getVar('menu_cotizaciones') ? 1 : 0,
                'menu_facturacion' => $this->request->getVar('menu_facturacion') ? 1 : 0,
                'menu_clientes' => $this->request->getVar('menu_clientes') ? 1 : 0,
                'menu_mercadolibre' => $this->request->getVar('menu_mercadolibre') ? 1 : 0,
                'menu_ordenes_ml' => $this->request->getVar('menu_ordenes_ml') ? 1 : 0,
                'menu_ordenes_venta' => $this->request->getVar('menu_ordenes_venta') ? 1 : 0,
                'menu_despachos' => $this->request->getVar('menu_despachos') ? 1 : 0,
                'menu_jumpseller' => $this->request->getVar('menu_jumpseller') ? 1 : 0,
                'menu_configuracion' => $this->request->getVar('menu_configuracion') ? 1 : 0
            ];
            
            $model->save($data);
            session()->setFlashdata('msg', 'Registro exitoso, ahora puede iniciar sesión');
            return redirect()->to('/auth/login');
        } else {
            return view('home_register', ['validation' => $this->validator]);
        }
    }
    
    public function logout()
    {
        session()->destroy();
        return redirect()->to('/auth/login');
    }
}