<?php

namespace App\Models;

use CodeIgniter\Model;

class ConfigModel extends Model
{
    protected $table = 'config_sistema';
    protected $primaryKey = 'id';
    protected $allowedFields = ['clave', 'valor', 'descripcion'];

    public function getConfig($clave)
    {
        return $this->where('clave', $clave)->first();
    }

    public function setConfig($clave, $valor, $descripcion = '')
    {
        $existente = $this->where('clave', $clave)->first();
        
        if ($existente) {
            return $this->update($existente['id'], [
                'valor' => $valor,
                'fecha_actualizacion' => date('Y-m-d H:i:s')
            ]);
        }
        
        return $this->insert([
            'clave' => $clave,
            'valor' => $valor,
            'descripcion' => $descripcion
        ]);
    }
}
