<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>Listado de Compras<?= $this->endSection() ?>

<?= $this->section('page_title') ?>Listado de Compras<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="techwave_fn_models_page">
    <div class="container">
        <!-- Header con acciones -->
        <div class="techwave_fn_feed">
            <div class="item">
                <div class="item__content">
                    <div class="item__header">
                        <div class="item__header_info">
                            <h3>Compras Registradas</h3>
                            <p>Gestiona todas las compras procesadas desde archivos XML DTE</p>
                        </div>
                        <div class="item__header_action">
                            <a href="<?= base_url('compras') ?>" class="techwave_fn_button">
                                <span>Nueva Compra</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabla de compras -->
        <div class="techwave_fn_feed">
            <div class="item">
                <div class="item__content">
                    <div class="item__table">
                        <table id="tablaCompras" class="techwave_fn_table">
                            <thead>
                                <tr>
                                    <th>N° Compra</th>
                                    <th>N° Control</th>
                                    <th>Fecha</th>
                                    <th>Proveedor</th>
                                    <th>Total</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($compras)): ?>
                                    <?php foreach ($compras as $compra): ?>
                                        <tr>
                                            <td><?= $compra['NumeroD'] ?></td>
                                            <td><?= $compra['NroCtrol'] ?? 'N/A' ?></td>
                                            <td><?= $compra['FechaE'] ?></td>
                                            <td><?= $compra['NombreProveedor'] ?? 'Sin nombre' ?></td>
                                            <td class="price">$<?= number_format($compra['MtoTotal'], 0, ',', '.') ?></td>
                                            <td>
                                                <div class="techwave_fn_button_group">
                                                    <a href="<?= base_url('compras/ver/' . $compra['NumeroD']) ?>" 
                                                       class="techwave_fn_button small secondary"
                                                       title="Ver Detalle">
                                                        <span>Ver</span>
                                                    </a>
                                                    <button type="button" 
                                                            class="techwave_fn_button small warning" 
                                                            onclick="anularCompra(<?= $compra['NumeroD'] ?>)"
                                                            title="Anular">
                                                        <span>Anular</span>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No hay compras registradas</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
jQuery(document).ready(function($) {
    // Inicializar DataTable si está disponible
    if ($.fn.DataTable) {
        $('#tablaCompras').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json"
            },
            "order": [[ 2, "desc" ]], // Ordenar por fecha descendente
            "columnDefs": [
                {
                    "targets": 5, // Columna de acciones
                    "orderable": false
                }
            ]
        });
    }
});

function anularCompra(numeroD) {
    Swal.fire({
        title: '¿Está seguro?',
        text: "Esta acción anulará la compra y ajustará el inventario",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, anular',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            jQuery.ajax({
                url: '<?= base_url('compras/anular') ?>/' + numeroD,
                method: 'POST',
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire(
                            'Anulada',
                            response.message,
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire(
                            'Error',
                            response.message,
                            'error'
                        );
                    }
                },
                error: function() {
                    Swal.fire(
                        'Error',
                        'Ocurrió un error al anular la compra',
                        'error'
                    );
                }
            });
        }
    });
}
</script>
<?= $this->endSection() ?>