<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Gestión de Facturas
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
GESTIÓN DE FACTURAS
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="card-title">Nueva Factura</h4>
                        <a href="<?= base_url('facturacion/listado') ?>" class="btn btn-primary">
                            <i class="fas fa-list"></i> Listar Facturas
                        </a>
                        <br>
                        <a href="<?= base_url('cotizaciones/listado_cotizaciones') ?>" class="btn btn-primary">
                            <i class="fas fa-list"></i> Listar Cotizaciones
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form id="cotizacionForm">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="cliente_id" class="form-label">Cliente</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="cliente_nombre" placeholder="Seleccione un cliente..." readonly>
                                        <input type="hidden" id="cliente_id" name="cliente_id" required>
                                        <input type="hidden" id="cliente_email" name="cliente_email">
                                        <button class="btn btn-outline-secondary" type="button" id="btnBuscarCliente">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                    <div id="cliente_seleccionado" class="form-text"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                            <div class="row mb-3">
                                                <label for="vendedor" class="col-sm-4 col-form-label">Vendedor:</label>
                                                <div class="col-sm-8">                                               
                                                
                                                    <select id="vendedor" class="form-select">
                                                        <option value="">Seleccione un vendedor</option>
                                                        <?php
                                                            foreach ($vendedores as $value) {
                                                                # code...
                                                                echo "<option value='". $value['CodVend']. "'>". $value['Descrip']. "</option>";
                                                            }                                                                                    
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="fecha" class="form-label">Fecha</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" value="<?= date('Y-m-d') ?>" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="notas" class="form-label">Notas</label>
                            <textarea class="form-control" id="notas" name="notas" rows="2"></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <h5>Productos</h5>
                                <button type="button" class="btn btn-primary btn-sm" id="btnAgregarProducto">
                                    <i class="fas fa-plus"></i> Agregar Producto
                                </button>
                            </div>
                            
                            <div class="table-responsive mt-3">
                                <table class="table table-bordered table-striped" id="tablaProductos">
                                    <thead>
                                        <tr>
                                            <th>SKU</th>
                                            <th>Descripción</th>
                                            <th>Cantidad</th>
                                            <th>Precio Unit.</th>
                                            <th>Subtotal</th>
                                            <th>IVA (16%)</th>
                                            <th>Total</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Los productos se agregarán con JavaScript -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="4" class="text-end"><strong>Totales:</strong></td>
                                            <td id="total_subtotal">0.00</td>
                                            <td id="total_iva">0.00</td>
                                            <td id="total_final">0.00</td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <button type="button" class="btn btn-secondary" id="btnCancelar">Cancelar</button>
                            <button type="submit" class="btn btn-primary" id="btnGuardar">Guardar Cotización</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<!-- Incluir SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function() {
        // Variables para almacenar los items de la cotización
        let items = [];
        
        // Evento para buscar clientes
        $('#btnBuscarCliente').on('click', function() {
            // Cargar datos de clientes mediante AJAX
            $.ajax({
                url: '<?= base_url('cotizaciones/buscar-clientes') ?>',
                type: 'POST',
                data: { term: '' },
                dataType: 'json',
                success: function(clientes) {
                    mostrarSweetAlertClientes(clientes);
                },
                error: function() {
                    Swal.fire('Error', 'No se pudieron cargar los clientes', 'error');
                }
            });
        });
        
        // Evento para agregar producto
        $('#btnAgregarProducto').on('click', function() {
            // Cargar datos de productos mediante AJAX
            $.ajax({
                url: '<?= base_url('cotizaciones/buscar-productos') ?>',
                type: 'POST',
                data: { term: '' },
                dataType: 'json',
                success: function(productos) {
                    mostrarSweetAlertProductos(productos);
                },
                error: function() {
                    Swal.fire('Error', 'No se pudieron cargar los productos', 'error');
                }
            });
        });
        
        // Función para mostrar SweetAlert con lista de clientes
        function mostrarSweetAlertClientes(clientes) {
            const ITEMS_POR_PAGINA = 10;
            let paginaActual = 1;
            let clientesFiltrados = clientes;
            
            function renderizarPagina(datos, pagina) {
                const inicio = (pagina - 1) * ITEMS_POR_PAGINA;
                const fin = inicio + ITEMS_POR_PAGINA;
                const datosPagina = datos.slice(inicio, fin);
                
                let filas = '';
                datosPagina.forEach(cliente => {
                    filas += `
                        <tr>
                            <td>${cliente.CodClie}</td>
                            <td>${cliente.Descrip}</td>
                            <td>${cliente.Email || ''}</td>
                            <td>${cliente.ID3 || ''}</td>
                            <td>
                                <button type="button" class="btn btn-sm btn-primary btnSeleccionarClienteSA" 
                                    data-codigo="${cliente.CodClie}" 
                                    data-nombre="${cliente.Descrip}"
                                    data-email="${cliente.Email || ''}" 
                                    data-id="${cliente.ID3 || ''}">
                                    Seleccionar
                                </button>
                            </td>
                        </tr>
                    `;
                });
                
                return filas;
            }
            
            function actualizarPaginacion(totalItems) {
                const totalPaginas = Math.ceil(totalItems / ITEMS_POR_PAGINA);
                let paginacionHtml = '';
                
                // Botón anterior
                paginacionHtml += `
                    <button class="btn btn-sm btn-outline-primary me-1 ${paginaActual === 1 ? 'disabled' : ''}" 
                            id="btnAnteriorCliente" ${paginaActual === 1 ? 'disabled' : ''}>
                        &laquo; Anterior
                    </button>
                `;
                
                // Números de página (mostrar máximo 5)
                const inicioNumero = Math.max(1, paginaActual - 2);
                const finNumero = Math.min(totalPaginas, inicioNumero + 4);
                
                for (let i = inicioNumero; i <= finNumero; i++) {
                    paginacionHtml += `
                        <button class="btn btn-sm ${i === paginaActual ? 'btn-primary' : 'btn-outline-primary'} me-1 btnPaginaCliente" 
                                data-pagina="${i}">
                            ${i}
                        </button>
                    `;
                }
                
                // Botón siguiente
                paginacionHtml += `
                    <button class="btn btn-sm btn-outline-primary btnSiguienteCliente ${paginaActual === totalPaginas ? 'disabled' : ''}" 
                            id="btnSiguienteCliente" ${paginaActual === totalPaginas ? 'disabled' : ''}>
                        Siguiente &raquo;
                    </button>
                `;
                
                return paginacionHtml;
            }
            
            const clientesHtml = `
                <div class="input-group mb-3">
                    <input type="text" id="buscarClienteSA" class="form-control" placeholder="Buscar cliente..." autocomplete="off">
                    <button class="btn btn-outline-secondary" type="button" id="btnLimpiarBusqueda">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <small class="text-muted">Mostrando <span id="infoResultados"></span> resultados</small>
                    <div id="paginacionClientes"></div>
                </div>
                <div style="max-height: 400px; overflow-y: auto;">
                    <table class="table table-sm table-hover">
                        <thead class="table-light sticky-top">
                            <tr>
                                <th style="cursor: pointer;" data-sort="CodClie">
                                    Código <i class="fas fa-sort"></i>
                                </th>
                                <th style="cursor: pointer;" data-sort="Descrip">
                                    Nombre <i class="fas fa-sort"></i>
                                </th>
                                <th>Email</th>
                                <th>Identificación</th>
                                <th width="100">Acción</th>
                            </tr>
                        </thead>
                        <tbody id="tablaClientesSA">
                            <!-- Contenido se carga dinámicamente -->
                        </tbody>
                    </table>
                </div>
                <div id="paginacionClientesInferior" class="d-flex justify-content-center mt-2">
                    <!-- Paginación inferior -->
                </div>
            `;
            
            Swal.fire({
                title: 'Seleccionar Cliente',
                html: clientesHtml,
                width: '900px',
                showCancelButton: true,
                showConfirmButton: false,
                cancelButtonText: 'Cerrar',
                didOpen: () => {
                    // Función para actualizar la tabla
                    function actualizarTabla() {
                        const filas = renderizarPagina(clientesFiltrados, paginaActual);
                        $('#tablaClientesSA').html(filas);
                        
                        const inicio = (paginaActual - 1) * ITEMS_POR_PAGINA + 1;
                        const fin = Math.min(paginaActual * ITEMS_POR_PAGINA, clientesFiltrados.length);
                        $('#infoResultados').text(`${inicio}-${fin} de ${clientesFiltrados.length}`);
                        
                        const paginacion = actualizarPaginacion(clientesFiltrados.length);
                        $('#paginacionClientes, #paginacionClientesInferior').html(paginacion);
                    }
                    
                    // Carga inicial
                    actualizarTabla();
                    
                    // Búsqueda con debounce
                    let timeoutBusqueda;
                    $('#buscarClienteSA').on('input', function() {
                        clearTimeout(timeoutBusqueda);
                        const term = $(this).val().toLowerCase().trim();
                        
                        timeoutBusqueda = setTimeout(() => {
                            if (term === '') {
                                clientesFiltrados = clientes;
                            } else {
                                clientesFiltrados = clientes.filter(cliente => 
                                    cliente.CodClie.toLowerCase().includes(term) ||
                                    cliente.Descrip.toLowerCase().includes(term) ||
                                    (cliente.Email && cliente.Email.toLowerCase().includes(term)) ||
                                    (cliente.ID3 && cliente.ID3.toLowerCase().includes(term))
                                );
                            }
                            paginaActual = 1;
                            actualizarTabla();
                        }, 300); // Debounce de 300ms
                    });
                    
                    // Limpiar búsqueda
                    $('#btnLimpiarBusqueda').on('click', function() {
                        $('#buscarClienteSA').val('');
                        clientesFiltrados = clientes;
                        paginaActual = 1;
                        actualizarTabla();
                    });
                    
                    // Eventos de paginación
                    $(document).on('click', '.btnPaginaCliente', function() {
                        paginaActual = parseInt($(this).data('pagina'));
                        actualizarTabla();
                    });
                    
                    $(document).on('click', '#btnAnteriorCliente', function() {
                        if (paginaActual > 1) {
                            paginaActual--;
                            actualizarTabla();
                        }
                    });
                    
                    $(document).on('click', '#btnSiguienteCliente', function() {
                        const totalPaginas = Math.ceil(clientesFiltrados.length / ITEMS_POR_PAGINA);
                        if (paginaActual < totalPaginas) {
                            paginaActual++;
                            actualizarTabla();
                        }
                    });
                    
                    // Ordenamiento
                    $('th[data-sort]').on('click', function() {
                        const campo = $(this).data('sort');
                        const icono = $(this).find('i');
                        
                        // Reset otros iconos
                        $('th[data-sort] i').removeClass('fa-sort-up fa-sort-down').addClass('fa-sort');
                        
                        // Determinar dirección
                        let ascendente = true;
                        if (icono.hasClass('fa-sort-up')) {
                            ascendente = false;
                            icono.removeClass('fa-sort-up').addClass('fa-sort-down');
                        } else {
                            icono.removeClass('fa-sort fa-sort-down').addClass('fa-sort-up');
                        }
                        
                        // Ordenar datos
                        clientesFiltrados.sort((a, b) => {
                            let valorA = a[campo] || '';
                            let valorB = b[campo] || '';
                            
                            if (typeof valorA === 'string') {
                                valorA = valorA.toLowerCase();
                                valorB = valorB.toLowerCase();
                            }
                            
                            if (ascendente) {
                                return valorA > valorB ? 1 : -1;
                            } else {
                                return valorA < valorB ? 1 : -1;
                            }
                        });
                        
                        paginaActual = 1;
                        actualizarTabla();
                    });
                    
                    // Selección de cliente
                    $(document).on('click', '.btnSeleccionarClienteSA', function() {
                        const codigo = $(this).data('codigo');
                        const nombre = $(this).data('nombre');
                        const email = $(this).data('email');
                        const id = $(this).data('id');
                        
                        $('#cliente_id').val(codigo);
                        $('#cliente_nombre').val(nombre);
                        $('#cliente_email').val(email);
                        $('#cliente_seleccionado').html(`<strong>${nombre}</strong> (${id}) (${email})`);
                        
                        Swal.close();
                    });
                }
            });
        }
        // function mostrarSweetAlertClientes(clientes) {
        //     let clientesHtml = `
        //         <div class="input-group mb-3">
        //             <input type="text" id="buscarClienteSA" class="form-control" placeholder="Buscar cliente...">
        //         </div>
        //         <div style="max-height: 400px; overflow-y: auto;">
        //             <table class="table table-bordered table-striped">
        //                 <thead>
        //                     <tr>
        //                         <th>Código</th>
        //                         <th>Nombre</th>
        //                         <th>Email</th>
        //                         <th>Identificación</th>
        //                         <th>Acción</th>
        //                     </tr>
        //                 </thead>
        //                 <tbody id="tablaClientesSA">
        //     `;
            
        //     clientes.forEach(cliente => {
        //         clientesHtml += `
        //             <tr>
        //                 <td>${cliente.CodClie}</td>
        //                 <td>${cliente.Descrip}</td>
        //                 <td>${cliente.Email}</td>
        //                 <td>${cliente.ID3 || ''}</td>
        //                 <td>
        //                     <button type="button" class="btn btn-sm btn-primary btnSeleccionarClienteSA" 
        //                         data-codigo="${cliente.CodClie}" 
        //                         data-nombre="${cliente.Descrip}"
        //                         data-email="${cliente.Email}" 
        //                         data-id="${cliente.ID3 || ''}">
        //                         Seleccionar
        //                     </button>
        //                 </td>
        //             </tr>
        //         `;
        //     });
            
        //     clientesHtml += `
        //                 </tbody>
        //             </table>
        //         </div>
        //     `;
            
        //     Swal.fire({
        //         title: 'Seleccionar Cliente',
        //         html: clientesHtml,
        //         width: '800px',
        //         showCancelButton: true,
        //         showConfirmButton: false,
        //         cancelButtonText: 'Cerrar',
        //         didOpen: () => {
        //             // Filtrar clientes al escribir
        //             $('#buscarClienteSA').on('keyup', function() {
        //                 const term = $(this).val().toLowerCase();
        //                 $('#tablaClientesSA tr').filter(function() {
        //                     $(this).toggle($(this).text().toLowerCase().indexOf(term) > -1);
        //                 });
        //             });
                    
        //             // Evento para seleccionar cliente
        //             $('.btnSeleccionarClienteSA').on('click', function() {
        //                 const codigo = $(this).data('codigo');
        //                 const nombre = $(this).data('nombre');
        //                 const email = $(this).data('email');
        //                 const id = $(this).data('id');
                        
        //                 $('#cliente_id').val(codigo);
        //                 $('#cliente_nombre').val(nombre);
        //                 $('#cliente_email').val(email);
        //                 $('#cliente_seleccionado').html(`<strong>${nombre}</strong> (${id}) (${email})`);
                        
        //                 Swal.close();
        //             });
        //         }
        //     });
        // }
        
        // Función para mostrar SweetAlert con lista de productos
        function mostrarSweetAlertProductos(productos) {
    const ITEMS_POR_PAGINA = 8;
    let paginaActual = 1;
    let productosFiltrados = productos;
    
    function renderizarPaginaProductos(datos, pagina) {
        const inicio = (pagina - 1) * ITEMS_POR_PAGINA;
        const fin = inicio + ITEMS_POR_PAGINA;
        const datosPagina = datos.slice(inicio, fin);
        
        let filas = '';
        datosPagina.forEach(producto => {
            const stock = parseFloat(producto.Existen || 0);
            const precio = parseFloat(producto.Precio1).toFixed(2);
            const stockClass = stock <= 0 ? 'text-danger' : stock <= 5 ? 'text-warning' : 'text-success';
            const stockIcon = stock <= 0 ? 'fa-times-circle' : stock <= 5 ? 'fa-exclamation-triangle' : 'fa-check-circle';
            
            filas += `
                <tr class="${stock <= 0 ? 'table-secondary' : ''}">
                    <td><code class="text-primary">${producto.CodProd}</code></td>
                    <td>
                        <div class="fw-bold text-truncate" style="max-width: 200px;" title="${producto.Descrip}">
                            ${producto.Descrip}
                        </div>
                        <small class="text-muted">SKU: ${producto.CodProd}</small>
                    </td>
                    <td class="${stockClass} fw-bold text-center">
                        <i class="fas ${stockIcon} me-1"></i>
                        ${stock.toFixed(0)}
                    </td>
                    <td class="text-end fw-bold">$${precio}</td>
                    <td class="text-center">
                        <button type="button" class="btn btn-sm ${stock <= 0 ? 'btn-secondary' : 'btn-primary'} btnSeleccionarProductoSA ${stock <= 0 ? 'disabled' : ''}" 
                            data-codigo="${producto.CodProd}" 
                            data-nombre="${producto.Descrip}" 
                            data-sku="${producto.CodProd || ''}" 
                            data-stock="${producto.Existen || '0'}" 
                            data-precio1="${producto.Precio1}"
                            data-precio2="${producto.Precio2 || producto.Precio1 * 0.9}"
                            data-precio3="${producto.Precio3 || producto.Precio1 * 0.8}"
                            ${stock <= 0 ? 'disabled' : ''}>
                            ${stock <= 0 ? '<i class="fas fa-ban"></i> Sin Stock' : '<i class="fas fa-plus"></i> Seleccionar'}
                        </button>
                    </td>
                </tr>
            `;
        });
        
        if (filas === '') {
            filas = `
                <tr>
                    <td colspan="5" class="text-center text-muted py-4">
                        <i class="fas fa-search fa-2x mb-2"></i>
                        <div>No se encontraron productos</div>
                        <small>Intenta con otros términos de búsqueda</small>
                    </td>
                </tr>
            `;
        }
        
        return filas;
    }
    
    function actualizarPaginacionProductos(totalItems) {
        const totalPaginas = Math.ceil(totalItems / ITEMS_POR_PAGINA);
        let paginacionHtml = '';
        
        if (totalPaginas <= 1) return '';
        
        // Botón anterior
        paginacionHtml += `
            <button class="btn btn-sm btn-outline-primary me-1 ${paginaActual === 1 ? 'disabled' : ''}" 
                    id="btnAnteriorProducto" ${paginaActual === 1 ? 'disabled' : ''}>
                <i class="fas fa-chevron-left"></i>
            </button>
        `;
        
        // Números de página (mostrar máximo 5)
        const inicioNumero = Math.max(1, paginaActual - 2);
        const finNumero = Math.min(totalPaginas, inicioNumero + 4);
        
        // Primera página si no está visible
        if (inicioNumero > 1) {
            paginacionHtml += `
                <button class="btn btn-sm btn-outline-primary me-1 btnPaginaProducto" data-pagina="1">1</button>
            `;
            if (inicioNumero > 2) {
                paginacionHtml += `<span class="me-1">...</span>`;
            }
        }
        
        // Páginas del rango
        for (let i = inicioNumero; i <= finNumero; i++) {
            paginacionHtml += `
                <button class="btn btn-sm ${i === paginaActual ? 'btn-primary' : 'btn-outline-primary'} me-1 btnPaginaProducto" 
                        data-pagina="${i}">
                    ${i}
                </button>
            `;
        }
        
        // Última página si no está visible
        if (finNumero < totalPaginas) {
            if (finNumero < totalPaginas - 1) {
                paginacionHtml += `<span class="me-1">...</span>`;
            }
            paginacionHtml += `
                <button class="btn btn-sm btn-outline-primary me-1 btnPaginaProducto" data-pagina="${totalPaginas}">${totalPaginas}</button>
            `;
        }
        
        // Botón siguiente
        paginacionHtml += `
            <button class="btn btn-sm btn-outline-primary btnSiguienteProducto ${paginaActual === totalPaginas ? 'disabled' : ''}" 
                    id="btnSiguienteProducto" ${paginaActual === totalPaginas ? 'disabled' : ''}>
                <i class="fas fa-chevron-right"></i>
            </button>
        `;
        
        return paginacionHtml;
    }
    
    // Crear el HTML del modal
    const productosHtml = `
        <div class="container-fluid">
            <!-- Barra de búsqueda y filtros -->
            <div class="row mb-3">
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-search"></i>
                        </span>
                        <input type="text" id="buscarProductoSA" class="form-control" 
                               placeholder="Buscar por código, descripción o SKU..." autocomplete="off">
                        <button class="btn btn-outline-secondary" type="button" id="btnLimpiarBusquedaProducto">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="col-md-4">
                    <select id="filtroStock" class="form-select">
                        <option value="">Todos los productos</option>
                        <option value="conStock">Solo con stock</option>
                        <option value="sinStock">Sin stock</option>
                        <option value="stockBajo">Stock bajo (≤5)</option>
                    </select>
                </div>
            </div>
            
            <!-- Información y paginación superior -->
            <div class="d-flex justify-content-between align-items-center mb-2">
                <div>
                    <small class="text-muted">
                        <i class="fas fa-info-circle me-1"></i>
                        Mostrando <span id="infoResultadosProductos" class="fw-bold"></span> resultados
                    </small>
                </div>
                <div id="paginacionProductos"></div>
            </div>
            
            <!-- Tabla de productos -->
            <div style="max-height: 450px; overflow-y: auto; border: 1px solid #dee2e6; border-radius: 0.375rem;">
                <table class="table table-sm table-hover mb-0">
                    <thead class="table-light sticky-top">
                        <tr>
                            <th style="cursor: pointer; min-width: 100px;" data-sort="CodProd">
                                <div class="d-flex align-items-center">
                                    Código 
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                </div>
                            </th>
                            <th style="cursor: pointer;" data-sort="Descrip">
                                <div class="d-flex align-items-center">
                                    Descripción 
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                </div>
                            </th>
                            <th style="cursor: pointer; text-align: center;" data-sort="Existen">
                                <div class="d-flex align-items-center justify-content-center">
                                    Stock 
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                </div>
                            </th>
                            <th style="cursor: pointer; text-align: right;" data-sort="Precio1">
                                <div class="d-flex align-items-center justify-content-end">
                                    Precio 
                                    <i class="fas fa-sort ms-1 text-muted"></i>
                                </div>
                            </th>
                            <th style="text-align: center; min-width: 120px;">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tablaProductosSA">
                        <!-- Contenido se carga dinámicamente -->
                    </tbody>
                </table>
            </div>
            
            <!-- Paginación inferior -->
            <div class="d-flex justify-content-center mt-3" id="paginacionProductosInferior">
                <!-- Paginación inferior -->
            </div>
            
            <!-- Leyenda -->
            <div class="mt-2">
                <small class="text-muted">
                    <i class="fas fa-check-circle text-success me-1"></i> En stock
                    <i class="fas fa-exclamation-triangle text-warning ms-2 me-1"></i> Stock bajo
                    <i class="fas fa-times-circle text-danger ms-2 me-1"></i> Sin stock
                </small>
            </div>
        </div>
    `;
    
    Swal.fire({
        title: '<i class="fas fa-box-open me-2"></i>Seleccionar Producto',
        html: productosHtml,
        width: '1000px',
        showCancelButton: true,
        showConfirmButton: false,
        cancelButtonText: '<i class="fas fa-times me-1"></i>Cerrar',
        customClass: {
            container: 'swal-productos-container'
        },
        didOpen: () => {
            // Función para actualizar la tabla
            function actualizarTablaProductos() {
                const filas = renderizarPaginaProductos(productosFiltrados, paginaActual);
                $('#tablaProductosSA').html(filas);
                
                const inicio = Math.min((paginaActual - 1) * ITEMS_POR_PAGINA + 1, productosFiltrados.length);
                const fin = Math.min(paginaActual * ITEMS_POR_PAGINA, productosFiltrados.length);
                $('#infoResultadosProductos').text(
                    productosFiltrados.length > 0 ? `${inicio}-${fin} de ${productosFiltrados.length}` : '0'
                );
                
                const paginacion = actualizarPaginacionProductos(productosFiltrados.length);
                $('#paginacionProductos, #paginacionProductosInferior').html(paginacion);
            }
            
            // Función para aplicar filtros
            function aplicarFiltros() {
                const termino = $('#buscarProductoSA').val().toLowerCase().trim();
                const filtroStock = $('#filtroStock').val();
                
                productosFiltrados = productos.filter(producto => {
                    // Filtro de búsqueda
                    const coincideBusqueda = termino === '' || 
                        producto.CodProd.toLowerCase().includes(termino) ||
                        producto.Descrip.toLowerCase().includes(termino);
                    
                    // Filtro de stock
                    const stock = parseFloat(producto.Existen || 0);
                    let coincideStock = true;
                    
                    switch (filtroStock) {
                        case 'conStock':
                            coincideStock = stock > 0;
                            break;
                        case 'sinStock':
                            coincideStock = stock <= 0;
                            break;
                        case 'stockBajo':
                            coincideStock = stock > 0 && stock <= 5;
                            break;
                    }
                    
                    return coincideBusqueda && coincideStock;
                });
                
                paginaActual = 1;
                actualizarTablaProductos();
            }
            
            // Carga inicial
            actualizarTablaProductos();
            
            // Búsqueda con debounce
            let timeoutBusqueda;
            $('#buscarProductoSA').on('input', function() {
                clearTimeout(timeoutBusqueda);
                timeoutBusqueda = setTimeout(aplicarFiltros, 300);
            });
            
            // Filtro de stock
            $('#filtroStock').on('change', aplicarFiltros);
            
            // Limpiar búsqueda
            $('#btnLimpiarBusquedaProducto').on('click', function() {
                $('#buscarProductoSA').val('');
                $('#filtroStock').val('');
                aplicarFiltros();
                $('#buscarProductoSA').focus();
            });
            
            // Eventos de paginación
            $(document).on('click', '.btnPaginaProducto', function() {
                paginaActual = parseInt($(this).data('pagina'));
                actualizarTablaProductos();
            });
            
            $(document).on('click', '#btnAnteriorProducto', function() {
                if (paginaActual > 1) {
                    paginaActual--;
                    actualizarTablaProductos();
                }
            });
            
            $(document).on('click', '#btnSiguienteProducto', function() {
                const totalPaginas = Math.ceil(productosFiltrados.length / ITEMS_POR_PAGINA);
                if (paginaActual < totalPaginas) {
                    paginaActual++;
                    actualizarTablaProductos();
                }
            });
            
            // Ordenamiento
            $('th[data-sort]').on('click', function() {
                const campo = $(this).data('sort');
                const icono = $(this).find('i');
                
                // Reset otros iconos
                $('th[data-sort] i').removeClass('fa-sort-up fa-sort-down').addClass('fa-sort');
                
                // Determinar dirección
                let ascendente = true;
                if (icono.hasClass('fa-sort-up')) {
                    ascendente = false;
                    icono.removeClass('fa-sort-up').addClass('fa-sort-down');
                } else {
                    icono.removeClass('fa-sort fa-sort-down').addClass('fa-sort-up');
                }
                
                // Ordenar datos
                productosFiltrados.sort((a, b) => {
                    let valorA = a[campo];
                    let valorB = b[campo];
                    
                    // Manejar valores numéricos
                    if (campo === 'Precio1' || campo === 'Existen') {
                        valorA = parseFloat(valorA || 0);
                        valorB = parseFloat(valorB || 0);
                    } else {
                        valorA = (valorA || '').toString().toLowerCase();
                        valorB = (valorB || '').toString().toLowerCase();
                    }
                    
                    if (ascendente) {
                        return valorA > valorB ? 1 : valorA < valorB ? -1 : 0;
                    } else {
                        return valorA < valorB ? 1 : valorA > valorB ? -1 : 0;
                    }
                });
                
                paginaActual = 1;
                actualizarTablaProductos();
            });
            
            // Selección de producto
            $(document).on('click', '.btnSeleccionarProductoSA', function() {
                if ($(this).hasClass('disabled')) return;
                
                const codigo = $(this).data('codigo');
                const nombre = $(this).data('nombre');
                const sku = $(this).data('sku');
                const stock = $(this).data('stock');
                const precio1 = parseFloat($(this).data('precio1'));
                const precio2 = parseFloat($(this).data('precio2'));
                const precio3 = parseFloat($(this).data('precio3'));
                
                // Mostrar dialog con opciones de precio y cantidad
                Swal.fire({
                    title: '<i class="fas fa-shopping-cart me-2"></i>Detalles del Producto',
                    html: `
                        <div class="container">
                            <div class="alert alert-info mb-3">
                                <strong>${nombre}</strong><br>
                                <small>Stock disponible: <span class="badge bg-primary">${stock}</span></small>
                            </div>
                            
                            <div class="row mb-3">
                                <label for="cantidad" class="col-sm-4 col-form-label fw-bold">Cantidad:</label>
                                <div class="col-sm-8">
                                    <input type="number" id="cantidad" class="form-control" value="1" 
                                           min="1" max="${stock}" step="1">
                                    <div class="form-text">Máximo disponible: ${stock}</div>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <label for="tipoPrecio" class="col-sm-4 col-form-label fw-bold">Tipo de precio:</label>
                                <div class="col-sm-8">
                                    <select id="tipoPrecio" class="form-select">
                                        <option value="precio1" data-precio="${precio1.toFixed(2)}">
                                            Precio 1: $${precio1.toFixed(2)}
                                        </option>
                                        <option value="precio2" data-precio="${precio2.toFixed(2)}">
                                            Precio 2: $${precio2.toFixed(2)} ${precio2 < precio1 ? '(Descuento)' : ''}
                                        </option>
                                        <option value="precio3" data-precio="${precio3.toFixed(2)}">
                                            Precio 3: $${precio3.toFixed(2)} ${precio3 < precio1 ? '(Mayor descuento)' : ''}
                                        </option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <label for="precio" class="col-sm-4 col-form-label fw-bold">Precio final:</label>
                                <div class="col-sm-8">
                                    <input type="number" id="precio" class="form-control" 
                                           value="${precio1.toFixed(2)}" step="0.01" min="${precio1.toFixed(2)}">
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-sm-4"></div>
                                <div class="col-sm-8">
                                    <div class="alert alert-light">
                                        <strong>Total: $<span id="totalCalculado">${precio1.toFixed(2)}</span></strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `,
                    width: '500px',
                    showCancelButton: true,
                    confirmButtonText: '<i class="fas fa-plus me-1"></i>Agregar Producto',
                    cancelButtonText: '<i class="fas fa-times me-1"></i>Cancelar',
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-secondary'
                    },
                    didOpen: () => {
                        // Actualizar precio cuando cambia el tipo
                        $('#tipoPrecio').on('change', function() {
                            const precioSeleccionado = $(this).find(':selected').data('precio');
                            $('#precio').val(precioSeleccionado);
                            actualizarTotal();
                        });
                        
                        // Actualizar total cuando cambia cantidad o precio
                        function actualizarTotal() {
                            const cantidad = parseFloat($('#cantidad').val() || 0);
                            const precio = parseFloat($('#precio').val() || 0);
                            $('#totalCalculado').text((cantidad * precio).toFixed(2));
                        }
                        
                        $('#cantidad, #precio').on('input', actualizarTotal);
                    },
                    preConfirm: () => {
                        const cantidad = parseFloat($('#cantidad').val());
                        const precio = parseFloat($('#precio').val());
                        
                        if (!cantidad || cantidad <= 0) {
                            Swal.showValidationMessage('La cantidad debe ser mayor a cero');
                            return false;
                        }
                        
                        if (cantidad > parseFloat(stock)) {
                            Swal.showValidationMessage(`La cantidad no puede ser mayor al stock disponible (${stock})`);
                            return false;
                        }
                        
                        if (!precio || precio <= 0) {
                            Swal.showValidationMessage('El precio debe ser mayor a cero');
                            return false;
                        }
                        
                        return { 
                            cantidad: cantidad, 
                            precio: precio
                        };
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Cerrar el modal de productos primero
                        Swal.close();
                        
                        // Agregar el producto
                        agregarProducto({
                            codigo: codigo,
                            nombre: nombre,
                            sku: sku,
                            cantidad: result.value.cantidad,
                            precio: result.value.precio
                        });
                    }
                });
            });
            
            // Enfocar el campo de búsqueda
            $('#buscarProductoSA').focus();
        }
    });
}
        // function mostrarSweetAlertProductos(productos) {
        //     let productosHtml = `
        //         <div class="input-group mb-3">
        //             <input type="text" id="buscarProductoSA" class="form-control" placeholder="Buscar producto...">
        //         </div>
        //         <div style="max-height: 400px; overflow-y: auto;">
        //             <table class="table table-bordered table-striped">
        //                 <thead>
        //                     <tr>
        //                         <th>Código</th>
        //                         <th>Descripción</th>
        //                         <th>SKU</th>
		// 		<th>STOCK</th>
        //                         <th>Precio</th>
        //                         <th>Acción</th>
        //                     </tr>
        //                 </thead>
        //                 <tbody id="tablaProductosSA">
        //     `;
            
        //     productos.forEach(producto => {
        //         productosHtml += `
        //             <tr>
        //                 <td>${producto.CodProd}</td>
        //                 <td>${producto.Descrip}</td>
        //                 <td>${producto.CodProd || ''}</td>
		// 	<td>${producto.Existen || '0'}</td>
        //                 <td>${parseFloat(producto.Precio1).toFixed(2)}</td>
        //                 <td>
        //                     <button type="button" class="btn btn-sm btn-primary btnSeleccionarProductoSA" 
        //                         data-codigo="${producto.CodProd}" 
        //                         data-nombre="${producto.Descrip}" 
        //                         data-sku="${producto.CodProd || ''}" 
		// 		data-stock="${producto.Existen || '0'}" 
        //                         data-precio1="${producto.Precio1}"
        //                         data-precio2="${producto.Precio2}"
        //                         data-precio3="${producto.Precio3}">
        //                         Seleccionar
        //                     </button>
        //                 </td>
        //             </tr>
        //         `;
        //     });
            
        //     productosHtml += `
        //                 </tbody>
        //             </table>
        //         </div>
        //     `;
            
        //     Swal.fire({
        //         title: 'Seleccionar Producto',
        //         html: productosHtml,
        //         width: '800px',
        //         showCancelButton: true,
        //         showConfirmButton: false,
        //         cancelButtonText: 'Cerrar',
        //         didOpen: () => {
        //             // Filtrar productos al escribir
        //             $('#buscarProductoSA').on('keyup', function() {
        //                 const term = $(this).val().toLowerCase();
        //                 $('#tablaProductosSA tr').filter(function() {
        //                     $(this).toggle($(this).text().toLowerCase().indexOf(term) > -1);
        //                 });
        //             });
                    
        //             // Evento para seleccionar producto
        //             $('.btnSeleccionarProductoSA').on('click', function() {
        //                 const codigo = $(this).data('codigo');
        //                 const nombre = $(this).data('nombre');
        //                 const sku = $(this).data('sku');
		// 	const stock = $(this).data('stock');
        //                 const precio1 = parseFloat($(this).data('precio1'));
        //                 const precio2 = parseFloat($(this).data('precio2') || precio1 * 0.9); // Por defecto 90% del precio1 si no existe
        //                 const precio3 = parseFloat($(this).data('precio3') || precio1 * 0.8); // Por defecto 80% del precio1 si no existe
                        
        //                 // Obtener los vendedores mediante una llamada AJAX
        //                 $.ajax({
        //                     url: '<?= base_url('cotizaciones/obtener-vendedores') ?>',
        //                     type: 'GET',
        //                     dataType: 'json',
        //                     success: function(vendedores) {
        //                         // Crear opciones para el select de vendedores
        //                         let opcionesVendedores = '';
        //                         vendedores.forEach(vendedor => {
        //                             opcionesVendedores += `<option value="${vendedor.CodVend}">${vendedor.Descrip}</option>`;
        //                         });
                                
        //                         // Mostrar dialog con opciones de precio y vendedor
        //                         Swal.fire({
        //                             title: 'Detalles del producto',
        //                             html: `
        //                                 <div class="container">
        //                                     <div class="row mb-3">
        //                                         <label for="cantidad" class="col-sm-4 col-form-label">Cantidad:</label>
        //                                         <div class="col-sm-8">
        //                                             <input type="number" id="cantidad" class="form-control" value="1" min="1" step="1">
        //                                         </div>
        //                                     </div>
        //                                     <div class="row mb-3">
        //                                         <label for="tipoPrecio" class="col-sm-4 col-form-label">Tipo de precio:</label>
        //                                         <div class="col-sm-8">
        //                                             <select id="tipoPrecio" class="form-select">
        //                                                 <option value="precio1" data-precio="${precio1.toFixed(2)}">Precio 1: ${precio1.toFixed(2)}</option>
        //                                                 <option value="precio2" data-precio="${precio2.toFixed(2)}">Precio 2: ${precio2.toFixed(2)}</option>
        //                                                 <option value="precio3" data-precio="${precio3.toFixed(2)}">Precio 3: ${precio3.toFixed(2)}</option>
        //                                             </select>
        //                                         </div>
        //                                     </div>
        //                                     <div class="row mb-3">
        //                                         <label for="precio" class="col-sm-4 col-form-label">Precio:</label>
        //                                         <div class="col-sm-8">
        //                                             <input type="number" id="precio" class="form-control" value="${precio1.toFixed(2)}" step="0.01">
        //                                         </div>
        //                                     </div>
                                            
        //                                 </div>
        //                             `,
        //                             showCancelButton: true,
        //                             confirmButtonText: 'Agregar',
        //                             cancelButtonText: 'Cancelar',
        //                             didOpen: () => {
        //                                 // Actualizar precio cuando cambia el tipo de precio
        //                                 $('#tipoPrecio').on('change', function() {
        //                                     const precioSeleccionado = $(this).find(':selected').data('precio');
        //                                     $('#precio').val(precioSeleccionado);
        //                                 });
        //                             },
        //                             preConfirm: () => {
        //                                 const cantidad = parseFloat($('#cantidad').val());
        //                                 const precio = parseFloat($('#precio').val());
        //                                 const vendedor = $('#vendedor').val();
                                        
        //                                 if (!cantidad || cantidad <= 0) {
        //                                     Swal.showValidationMessage('La cantidad debe ser mayor a cero');
        //                                     return false;
        //                                 }
                                        
        //                                 if (!precio || precio <= 0) {
        //                                     Swal.showValidationMessage('El precio debe ser mayor a cero');
        //                                     return false;
        //                                 }

		// 			if (parseFloat(stock) == 0 || cantidad > parseFloat(stock)) {
        //                                     Swal.showValidationMessage('No tienes stock en este producto');
        //                                     return false;
        //                                 }
                                        
        //                                 return { 
        //                                     cantidad: cantidad, 
        //                                     precio: precio,
        //                                     vendedor: vendedor
        //                                 };
        //                             }
        //                         }).then((result) => {
        //                             if (result.isConfirmed) {
        //                                 agregarProducto({
        //                                     codigo: codigo,
        //                                     nombre: nombre,
        //                                     sku: sku,
        //                                     cantidad: result.value.cantidad,
        //                                     precio: result.value.precio,
        //                                     vendedor: result.value.vendedor
        //                                 });
        //                             }
        //                         });
        //                     },
        //                     error: function() {
        //                         // Si falla la carga de vendedores, mostrar solo opciones de precio
        //                         Swal.fire({
        //                             title: 'Detalles del producto',
        //                             html: `
        //                                 <div class="container">
        //                                     <div class="row mb-3">
        //                                         <label for="cantidad" class="col-sm-4 col-form-label">Cantidad:</label>
        //                                         <div class="col-sm-8">
        //                                             <input type="number" id="cantidad" class="form-control" value="1" min="1" step="1">
        //                                         </div>
        //                                     </div>
        //                                     <div class="row mb-3">
        //                                         <label for="tipoPrecio" class="col-sm-4 col-form-label">Tipo de precio:</label>
        //                                         <div class="col-sm-8">
        //                                             <select id="tipoPrecio" class="form-select">
        //                                                 <option value="precio1" data-precio="${precio1.toFixed(2)}">Precio 1: ${precio1.toFixed(2)}</option>
        //                                                 <option value="precio2" data-precio="${precio2.toFixed(2)}">Precio 2: ${precio2.toFixed(2)}</option>
        //                                                 <option value="precio3" data-precio="${precio3.toFixed(2)}">Precio 3: ${precio3.toFixed(2)}</option>
        //                                             </select>
        //                                         </div>
        //                                     </div>
        //                                     <div class="row mb-3">
        //                                         <label for="precio" class="col-sm-4 col-form-label">Precio:</label>
        //                                         <div class="col-sm-8">
        //                                             <input type="number" id="precio" class="form-control" value="${precio1.toFixed(2)}" step="0.01">
        //                                         </div>
        //                                     </div>
        //                                 </div>
        //                             `,
        //                             showCancelButton: true,
        //                             confirmButtonText: 'Agregar',
        //                             cancelButtonText: 'Cancelar',
        //                             didOpen: () => {
        //                                 // Actualizar precio cuando cambia el tipo de precio
        //                                 $('#tipoPrecio').on('change', function() {
        //                                     const precioSeleccionado = $(this).find(':selected').data('precio');
        //                                     $('#precio').val(precioSeleccionado);
        //                                 });
        //                             },
        //                             preConfirm: () => {
        //                                 const cantidad = parseFloat($('#cantidad').val());
        //                                 const precio = parseFloat($('#precio').val());
                                        
        //                                 if (!cantidad || cantidad <= 0) {
        //                                     Swal.showValidationMessage('La cantidad debe ser mayor a cero');
        //                                     return false;
        //                                 }
                                        
        //                                 if (!precio || precio <= 0) {
        //                                     Swal.showValidationMessage('El precio debe ser mayor a cero');
        //                                     return false;
        //                                 }

		// 			if (parseFloat(stock) == 0 || cantidad > parseFloat(stock)) {
        //                                     Swal.showValidationMessage('No tienes stock en este producto');
        //                                     return false;
        //                                 }
                                        
        //                                 return { 
        //                                     cantidad: cantidad, 
        //                                     precio: precio,
        //                                     vendedor: ''
        //                                 };
        //                             }
        //                         }).then((result) => {
        //                             if (result.isConfirmed) {
        //                                 agregarProducto({
        //                                     codigo: codigo,
        //                                     nombre: nombre,
        //                                     sku: sku,
        //                                     cantidad: result.value.cantidad,
        //                                     precio: result.value.precio,
        //                                     vendedor: result.value.vendedor
        //                                 });
        //                             }
        //                         });
        //                     }
        //                 });
        //             });
        //             // $('.btnSeleccionarProductoSA').on('click', function() {
        //             //     const codigo = $(this).data('codigo');
        //             //     const nombre = $(this).data('nombre');
        //             //     const sku = $(this).data('sku');
        //             //     const precio = parseFloat($(this).data('precio'));
                        
        //             //     // Solicitar la cantidad
        //             //     Swal.fire({
        //             //         title: 'Ingrese la cantidad',
        //             //         input: 'number',
        //             //         inputValue: 1,
        //             //         inputAttributes: {
        //             //             min: 1,
        //             //             step: 1
        //             //         },
        //             //         showCancelButton: true,
        //             //         confirmButtonText: 'Agregar',
        //             //         cancelButtonText: 'Cancelar',
        //             //         inputValidator: (value) => {
        //             //             if (!value || value <= 0) {
        //             //                 return 'Debe ingresar una cantidad válida';
        //             //             }
        //             //         }
        //             //     }).then((result) => {
        //             //         if (result.isConfirmed) {
        //             //             agregarProducto({
        //             //                 codigo: codigo,
        //             //                 nombre: nombre,
        //             //                 sku: sku,
        //             //                 cantidad: parseFloat(result.value),
        //             //                 precio: precio
        //             //             });
        //             //         }
        //             //     });
        //             // });
        //         }
        //     });
        // }
        
        // Agregar producto a la tabla
        function agregarProducto(producto) {
            // Verificar si el producto ya existe
            const existeIndex = items.findIndex(item => item.sku === producto.sku);
            if (existeIndex >= 0) {
                // Actualizar cantidad
                items[existeIndex].cantidad += producto.cantidad;
                actualizarTablaProductos();
                return;
            }
            
            const subtotal = producto.cantidad * producto.precio;
            const iva = subtotal * 0.16; // 16% IVA
            const total = subtotal + iva;
            
            // Agregar a la lista de items
            items.push({
                codigo: producto.codigo,
                nombre: producto.nombre,
                sku: producto.sku,
                cantidad: producto.cantidad,
                precio: producto.precio,
                subtotal: subtotal,
                iva: iva,
                total: total,
                vendedor: producto.vendedor
            });
            
            actualizarTablaProductos();
        }
        
        // Actualizar la tabla de productos
        function actualizarTablaProductos() {
            let html = '';
            let totalSubtotal = 0;
            let totalIva = 0;
            let totalFinal = 0;
            
            items.forEach((item, index) => {
                // Recalcular totales
                const subtotal = item.cantidad * item.precio;
                const iva = subtotal * 0.16;
                const total = subtotal + iva;
                
                // Actualizar item
                items[index].subtotal = subtotal;
                items[index].iva = iva;
                items[index].total = total;
                
                // Sumar a los totales
                totalSubtotal += subtotal;
                totalIva += iva;
                totalFinal += total;
                
                html += `
                <tr>
                    <td>${item.sku}</td>
                    <td>${item.nombre}</td>
                    <td>${item.cantidad}</td>
                    <td>${item.precio.toFixed(2)}</td>
                    <td>${subtotal.toFixed(2)}</td>
                    <td>${iva.toFixed(2)}</td>
                    <td>${total.toFixed(2)}</td>
                    <td>
                        <button type="button" class="btn btn-sm btn-danger btnEliminarProducto" data-index="${index}">
                            <i class="fas fa-trash"></i>
                        </button>
                        <button type="button" class="btn btn-sm btn-warning btnEditarProducto" data-index="${index}">
                            <i class="fas fa-edit"></i>
                        </button>
                    </td>
                </tr>
                `;
            });
            
            $('#tablaProductos tbody').html(html);
            $('#total_subtotal').text(totalSubtotal.toFixed(2));
            $('#total_iva').text(totalIva.toFixed(2));
            $('#total_final').text(totalFinal.toFixed(2));
        }
        
        // Eliminar producto
        $(document).on('click', '.btnEliminarProducto', function() {
            const index = $(this).data('index');
            
            Swal.fire({
                title: '¿Está seguro?',
                text: "¿Desea eliminar este producto de la cotización?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    items.splice(index, 1);
                    actualizarTablaProductos();
                }
            });
        });
        
        // Editar producto
        $(document).on('click', '.btnEditarProducto', function() {
            const index = $(this).data('index');
            const item = items[index];
            
            Swal.fire({
                title: 'Editar Producto',
                html: `
                    <div class="container">
                        <div class="row mb-3">
                            <label class="col-sm-4 col-form-label">Cantidad:</label>
                            <div class="col-sm-8">
                                <input type="number" id="editCantidad" class="form-control" value="${item.cantidad}" min="1" step="1">
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-4 col-form-label">Precio:</label>
                            <div class="col-sm-8">
                                <input type="number" id="editPrecio" class="form-control" value="${item.precio}" min="0" step="0.01">
                            </div>
                        </div>
                    </div>
                `,
                showCancelButton: true,
                confirmButtonText: 'Guardar',
                cancelButtonText: 'Cancelar',
                preConfirm: () => {
                    const cantidad = parseFloat(document.getElementById('editCantidad').value);
                    const precio = parseFloat(document.getElementById('editPrecio').value);
                    
                    if (isNaN(cantidad) || cantidad <= 0) {
                        Swal.showValidationMessage('La cantidad debe ser un número mayor a cero');
                        return false;
                    }
                    
                    if (isNaN(precio) || precio <= 0) {
                        Swal.showValidationMessage('El precio debe ser un número mayor a cero');
                        return false;
                    }
                    
                    return { cantidad: cantidad, precio: precio };
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    items[index].cantidad = result.value.cantidad;
                    items[index].precio = result.value.precio;
                    actualizarTablaProductos();
                }
            });
        });
        
        // Guardar cotización
        $('#cotizacionForm').on('submit', function(e) {
            e.preventDefault();
            
            if (!$('#cliente_id').val()) {
                Swal.fire('Error', 'Debe seleccionar un cliente', 'error');
                return;
            }
            
            if (items.length === 0) {
                Swal.fire('Error', 'Debe agregar al menos un producto', 'error');
                return;
            }
            
            // Calcular totales finales
            const subtotal = parseFloat($('#total_subtotal').text());
            const impuesto = parseFloat($('#total_iva').text());
            const total = parseFloat($('#total_final').text());
            
            // Preparar datos para enviar
            const formData = {
                cliente_id: $('#cliente_id').val(),
                cliente_email: $('#cliente_email').val(),
                vendedor: $('#vendedor').val(),
                notas: $('#notas').val(),
                items: JSON.stringify(items),
                subtotal: subtotal,
                impuesto: impuesto,
                total: total
            };
            
            // Mostrar confirmación
            Swal.fire({
                title: '¿Guardar factura?',
                text: "¿Está seguro que desea guardar esta factura?",
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Sí, guardar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Enviar datos al servidor
                    $.ajax({
                        url: '<?= base_url('facturacion/crear') ?>',
                        type: 'POST',
                        data: formData,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                Swal.fire({
                                    title: '¡Éxito!',
                                    text: response.message,
                                    icon: 'success',
                                    showCancelButton: true,
                                    confirmButtonText: 'Ver factura',
                                    cancelButtonText: 'Nueva factura'
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        // Redirigir a ver la cotización
                                        window.location.href = '<?= base_url('facturacion/ver/') ?>' + response.cotizacion_id;
                                    } else {
                                        // Limpiar formulario
                                        $('#cliente_id').val('');
                                        $('#cliente_nombre').val('');
                                        $('#cliente_email').val('');
                                        $('#cliente_seleccionado').html('');
                                        $('#notas').val('');
                                        items = [];
                                        actualizarTablaProductos();
                                    }
                                });
                            } else {
                                Swal.fire('Error', response.message, 'error');
                            }
                        },
                        error: function() {
                            Swal.fire('Error', 'Error en la solicitud', 'error');
                        }
                    });
                }
            });
        });
        
        // Cancelar cotización
        $('#btnCancelar').on('click', function() {
            Swal.fire({
                title: '¿Cancelar cotización?',
                text: "Se perderán todos los datos ingresados",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, cancelar',
                cancelButtonText: 'No, seguir editando'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Limpiar formulario
                    $('#cliente_id').val('');
                    $('#cliente_nombre').val('');
                    $('#cliente_email').val('');
                    $('#cliente_seleccionado').html('');
                    $('#notas').val('');
                    items = [];
                    actualizarTablaProductos();
                }
            });
        });
    });
</script>
<?= $this->endSection() ?>