<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>Gestión de Compras<?= $this->endSection() ?>

<?= $this->section('page_title') ?>Procesar Factura de Compra (XML DTE)<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="techwave_fn_models_page">
    <div class="container">
        <!-- Formulario para subir XML -->
        <div class="techwave_fn_feed">
            <div class="item">
                <div class="item__content">
                    <div class="item__header">
                        <h3>Cargar Archivo XML DTE</h3>
                        <p>Seleccione el archivo XML del DTE de la factura de compra para procesarlo automáticamente</p>
                    </div>
                    
                    <div class="item__form">
                        <form id="formProcesarXML" enctype="multipart/form-data">
                            <div class="techwave_fn_interactive_list">
                                <div class="item">
                                    <label for="xml_file">Archivo XML DTE</label>
                                    <input type="file" 
                                           id="xml_file" 
                                           name="xml_file" 
                                           accept=".xml" 
                                           required
                                           class="techwave_fn_input">
                                    <span class="input_description">Formatos soportados: XML</span>
                                </div>
                            </div>
                            
                            <div class="techwave_fn_interactive_list">
                                <div class="item">
                                    <button type="submit" 
                                            class="techwave_fn_button" 
                                            id="btnProcesar">
                                        <span>Procesar XML</span>
                                    </button>
                                    <a href="<?= base_url('compras/listado') ?>" 
                                       class="techwave_fn_button secondary">
                                        <span>Ver Compras</span>
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Panel de información del XML -->
        <div class="techwave_fn_feed" id="panelInfoXML" style="display: none;">
            <div class="item">
                <div class="item__content">
                    <div class="item__header">
                        <h3>Información del XML</h3>
                    </div>
                    <div class="item__description" id="infoXMLContent">
                        <!-- Información del XML se carga aquí -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Asegurar que jQuery está disponible
jQuery(document).ready(function($) {
    $('#formProcesarXML').on('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData(this);
        var btnProcesar = $('#btnProcesar');
        
        // Validar que se haya seleccionado un archivo
        if (!$('#xml_file').val()) {
            Swal.fire({
                icon: 'warning',
                title: 'Advertencia',
                text: 'Por favor seleccione un archivo XML'
            });
            return;
        }
        
        btnProcesar.prop('disabled', true).html('<span>Procesando...</span>');
        
        $.ajax({
            url: '<?= base_url('compras/procesarXML') ?>',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Éxito',
                        text: response.message,
                        showConfirmButton: true,
                        confirmButtonText: 'Ver Compra'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = '<?= base_url('compras/ver') ?>/' + response.compra_id;
                        } else {
                            location.reload();
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message
                    });
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Ocurrió un error al procesar el XML'
                });
            },
            complete: function() {
                btnProcesar.prop('disabled', false).html('<span>Procesar XML</span>');
            }
        });
    });
    
    // Previsualizar información del XML seleccionado
    $('#xml_file').on('change', function() {
        var file = this.files[0];
        if (file) {
            if (file.type !== 'text/xml' && !file.name.endsWith('.xml')) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Formato no válido',
                    text: 'Por favor seleccione un archivo XML válido'
                });
                $(this).val('');
                return;
            }
            
            // Mostrar información básica del archivo
            $('#panelInfoXML').show();
            $('#infoXMLContent').html(
                '<p><strong>Archivo:</strong> ' + file.name + '</p>' +
                '<p><strong>Tamaño:</strong> ' + (file.size / 1024).toFixed(2) + ' KB</p>' +
                '<p><strong>Tipo:</strong> ' + (file.type || 'XML') + '</p>'
            );
        } else {
            $('#panelInfoXML').hide();
        }
    });
});
</script>
<?= $this->endSection() ?>