<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Detalle de Cotización #<?= $cotizacion['NumeroD'] ?>
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
DETALLE DE COTIZACIÓN #<?= $cotizacion['NumeroD'] ?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="card-title">Información de la Cotización</h4>
                        <div>
                            <a href="<?= base_url('cotizaciones/pdf/' . $cotizacion['NumeroD']) ?>" class="btn btn-danger" target="_blank">
                                <i class="fas fa-file-pdf"></i> Generar PDF
                            </a>
                            <!-- <a href="<?= base_url('cotizaciones/convertir/' . $cotizacion['NumeroD']) ?>" class="btn btn-success">
                                <i class="fas fa-exchange-alt"></i> Convertir a Factura
                            </a> -->
                            <a href="<?= base_url('cotizaciones/listado') ?>" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Volver
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5>Información del Cliente</h5>
                            <table class="table table-sm">
                                <tr>
                                    <th>Cliente:</th>
                                    <td><?= $cotizacion['NombreCliente'] ?></td>
                                </tr>
                                <tr>
                                    <th>Identificación:</th>
                                    <td><?= $cotizacion['ClienteID'] ?></td>
                                </tr>
                                <tr>
                                    <th>Código:</th>
                                    <td><?= $cotizacion['CodClie'] ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5>Información de la Cotización</h5>
                            <table class="table table-sm">
                                <tr>
                                    <th>Número:</th>
                                    <td><?= $cotizacion['NumeroD'] ?></td>
                                </tr>
                                <tr>
                                    <th>Fecha:</th>
                                    <td><?= date('d/m/Y', strtotime($cotizacion['FechaE'])) ?></td>
                                </tr>
                                <tr>
                                    <th>Válida hasta:</th>
                                    <td><?= date('d/m/Y', strtotime($cotizacion['FechaV'])) ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <?php if (!empty($cotizacion['Notas1'])): ?>
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <strong>Notas:</strong> <?= $cotizacion['Notas1'] ?>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5>Productos</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Código</th>
                                            <th>Descripción</th>
                                            <th>Cantidad</th>
                                            <th>Precio Unit.</th>
                                            <th>Subtotal</th>
                                            <th>IVA</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($detalles as $i => $detalle): ?>
                                        <tr>
                                            <td><?= $i + 1 ?></td>
                                            <td><?= $detalle['CodItem'] ?></td>
                                            <td><?= $detalle['Descrip1'] ?></td>
                                            <td><?= $detalle['Cantidad'] ?></td>
                                            <td><?= number_format($detalle['Precio'], 2) ?></td>
                                            <td><?= number_format($detalle['Cantidad'] * $detalle['Precio'], 2) ?></td>
                                            <td><?= number_format($detalle['MtoTax'], 2) ?></td>
                                            <td><?= number_format($detalle['TotalItem'], 2) ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="5" class="text-end"><strong>Totales:</strong></td>
                                            <td><strong><?= number_format($cotizacion['TGravable'], 2) ?></strong></td>
                                            <td><strong><?= number_format($cotizacion['MtoTax'], 2) ?></strong></td>
                                            <td><strong><?= number_format($cotizacion['MtoTotal'], 2) ?></strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>