<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Listado de Facturas
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
LISTADO DE FACTURAS
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="card-title">FACTURAS</h4>
                        <a href="<?= base_url('facturacion') ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Nueva Factura
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="tablaCotizaciones">
                            <thead>
                                <tr>
                                    <th>Número</th>
                                    <th>Fecha</th>
                                    <th>Cliente</th>
                                    <th>Total</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($facturas as $cotizacion): ?>
                                <tr>
                                    <td><?= $cotizacion['NumeroD'] ?></td>
                                    <td><?= date('d/m/Y', strtotime($cotizacion['FechaE'])) ?></td>
                                    <td><?= $cotizacion['NombreCliente'] ?></td>
                                    <td><?= number_format($cotizacion['MtoTotal'], 2) ?></td>
                                    <td>
                                        <a href="<?= base_url('facturacion/ver/' . $cotizacion['NumeroD']) ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye">VER</i>
                                        </a>
                                        <a href="<?= base_url('facturacion/pdf/' . $cotizacion['NumeroD']) ?>" class="btn btn-sm btn-danger" target="_blank">
                                            <i class="fas fa-file-pdf">PDF</i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    $(document).ready(function() {
        $('#tablaCotizaciones').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
            },
            "order": [[1, "desc"]]
        });
    });
</script>
<?= $this->endSection() ?>