<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Editar Producto
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
Editar Producto
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container small">
        <div class="user__billing">
            <div class="billing__info">
                <div class="info__content">
                    <div class="fn__title_holder">
                        <h2 class="title">Información del Producto</h2>
                    </div>
                    
                    <div class="fn__form_item">
                        <label for="codigo">Código:</label>
                        <input type="text" id="codigo" value="<?= esc($producto['CodProd']) ?>" readonly>
                    </div>
                    
                    <div class="fn__form_item">
                        <label for="descripcion">Descripción:</label>
                        <input type="text" id="descripcion" value="<?= esc($producto['Descrip']) ?>" readonly>
                    </div>
                    
                    <div class="fn__form_item">
                        <label for="existencia">Existencia:</label>
                        <input type="text" id="existencia" value="<?= esc($producto['Existen']) ?>" readonly>
                    </div>
                    
                    <div class="fn__form_item">
                        <label for="ubicacion">Ubicación:</label>
                        <input type="text" id="ubicacion" value="<?= esc($producto['PuestoI']) ?>">
                    </div>
                    
                    <div class="fn__form_item">
                        <button type="button" id="guardarBtn" class="techwave_fn_button">
                            <span>Guardar Cambios</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const guardarBtn = document.getElementById('guardarBtn');
    const ubicacionInput = document.getElementById('ubicacion');
    
    guardarBtn.addEventListener('click', function() {
        const nuevaPosicion = ubicacionInput.value;
        
        $.ajax({
            url: '<?= base_url('editar/guardar') ?>',
            method: 'POST',
            data: {
                prod_id: '<?= $producto['CodProd'] ?>',
                bodega: '<?= $producto['CodUbic'] ?>',
                posicion: nuevaPosicion
            },
            success: function(response) {
                if (response.success) {
                    alert('Ubicación actualizada correctamente');
                    // Opcional: redirigir al buscador
                    // window.location.href = '<?= base_url() ?>';
                } else {
                    alert('Error al actualizar la ubicación');
                }
            },
            error: function(xhr, status, error) {
                alert('Error al guardar los cambios: ' + error);
            }
        });
    });
});
</script>
<?= $this->endSection() ?>