<?php

namespace App\Controllers;

class Config extends BaseController
{
    protected $configModel;

    public function __construct()
    {
        $this->configModel = new \App\Models\ConfigModel();
    }

    public function index()
    {
        // $data['db_config'] = [
        //     'hostname' => $this->configModel->getConfig('db_hostname'),
        //     'username' => $this->configModel->getConfig('db_username'),
        //     'password' => $this->configModel->getConfig('db_password'),
        //     'database' => $this->configModel->getConfig('db_database')
        // ];
        // Leer configuración actual
        $configFile = WRITEPATH . 'db_config.php';
        $currentConfig = [];
        
        if (file_exists($configFile)) {
            $currentConfig = include($configFile);
        }
        
        $data['db_config'] = $currentConfig;

        $data['ml_config'] = [
            'client_id' => $this->configModel->getConfig('ml_client_id'),
            'client_secret' => $this->configModel->getConfig('ml_client_secret'),
            'access_token' => $this->configModel->getConfig('ml_access_token'),
            'refresh_token' => $this->configModel->getConfig('ml_refresh_token')
        ];

        return view('home_config', $data);
    }

    public function guardar()
    {
        if ($this->request->isAJAX()) {
            $tipo = $this->request->getPost('tipo');
            $datos = $this->request->getPost('datos');

            try {
                foreach ($datos as $clave => $valor) {
                    $this->configModel->setConfig($tipo . '_' . $clave, $valor);
                }

                return $this->response->setJSON([
                    'success' => true,
                    'message' => 'Configuración guardada correctamente'
                ]);
            } catch (\Exception $e) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => 'Error al guardar la configuración: ' . $e->getMessage()
                ]);
            }
        }
    }
    public function guardarDB()
    {
        if ($this->request->isAJAX()) {
            $config = [
                'hostname' => $this->request->getPost('hostname'),
                'username' => $this->request->getPost('username'),
                'password' => $this->request->getPost('password'),
                'database' => $this->request->getPost('database'),
                'DBDriver' => 'SQLSRV',
                'port'     => 1433,
                'schema'   => 'dbo'
            ];

            // Crear el contenido del archivo
            $configContent = "<?php\nreturn " . var_export($config, true) . ";\n";
            
            try {
                // Verificar si el directorio writable existe y tiene permisos
                if (!is_dir(WRITEPATH)) {
                    mkdir(WRITEPATH, 0777, true);
                }
                
                // Guardar la configuración
                if (write_file(WRITEPATH . 'db_config.php', $configContent)) {
                    return $this->response->setJSON([
                        'success' => true,
                        'message' => 'Configuración guardada. La aplicación debe ser reiniciada para aplicar los cambios.'
                    ]);
                } else {
                    throw new \Exception('No se pudo escribir el archivo de configuración');
                }
            } catch (\Exception $e) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => 'Error al guardar la configuración: ' . $e->getMessage()
                ]);
            }
        }
    }
}