<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Órdenes de MercadoLibre
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
Órdenes de MercadoLibre
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container small">
        <div class="fn__title_holder">
            <h3>Listado de Órdenes de MercadoLibre</h3>
            <div class="fn__buttons">
                <button id="btnSincronizar" class="techwave_fn_button">
                    <span>Sincronizar Órdenes</span>
                </button>
            </div>
        </div>
        
        <div class="fn__table_wrap">
            <table id="tblOrdenes" class="display">
                <thead>
                    <tr>
                        <th>Orden ID</th>
                        <th>Fecha</th>
                        <th>Comprador</th>
                        <th>Productos</th>
                        <th>Total</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Se llena vía AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal de estado -->
<div class="modal fade" id="statusModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Estado</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="statusModalBody">
                <!-- Contenido dinámico -->
            </div>
            <div class="modal-footer">
                <button type="button" class="techwave_fn_button small" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    if ($.fn.DataTable.isDataTable('#tblOrdenes')) {
        $('#tblOrdenes').DataTable().destroy();
    }

    const table = $('#tblOrdenes').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?= base_url('mercadolibre_orders/listarOrdenes') ?>',
            type: 'GET'
        },
        columns: [
            { 
                data: 'order_id',
                title: 'Orden ID'
            },
            { 
                data: 'date_created',
                title: 'Fecha',
                render: function(data, type, row) {
                    if (type === 'display') {
                        let fecha = new Date(data);
                        return fecha.toLocaleDateString('es-ES', {
                            day: '2-digit',
                            month: '2-digit',
                            year: 'numeric',
                            hour: '2-digit',
                            minute: '2-digit'
                        });
                    }
                    return data;
                }
            },
            { 
                data: 'buyer_nickname',
                title: 'Comprador'
            },
            { 
                data: 'items_count',
                title: 'N° Productos',
                className: 'text-center'
            },
            { 
                data: 'total_amount',
                title: 'Total',
                render: function(data, type, row) {
                    if (type === 'display') {
                        return new Intl.NumberFormat('es-AR', {
                            style: 'currency',
                            currency: row.currency_id
                        }).format(data);
                    }
                    return data;
                }
            },
            { 
                data: 'status',
                title: 'Estado',
                render: function(data, type, row) {
                    if (type === 'display') {
                        let statusClass = '';
                        let statusText = '';
                        
                        switch(data) {
                            case 'paid':
                                statusClass = 'badge badge-success';
                                statusText = 'Pagado';
                                break;
                            case 'cancelled':
                                statusClass = 'badge badge-danger';
                                statusText = 'Cancelado';
                                break;
                            default:
                                statusClass = 'badge badge-secondary';
                                statusText = data;
                                break;
                        }
                        
                        return `<span class="${statusClass}">${statusText}</span>`;
                    }
                    return data;
                }
            },
            { 
                data: null,
                title: 'Acciones',
                orderable: false,
                render: function(data, type, row) {
                    let buttonHtml = `
                        <a href="<?= base_url('mercadolibre_orders/detalleOrden') ?>/${row.order_id}" 
                           class="techwave_fn_button small mb-2">
                           <span>Ver Detalle</span>
                        </a>`;
                    
                    // Si no ha sido procesada, agregar botón de factura
                    if (row.processed != 1) {
                        buttonHtml += `
                            <button
                               class="techwave_fn_button small btn-crear-factura"
                               data-order-id="${row.order_id}">
                               <span>Crear Factura</span>
                            </button>`;
                    } else {
                        buttonHtml += `
                            <div class="text-success">
                                <small>Factura: ${row.invoice_id}</small>
                            </div>`;
                    }
                    
                    return buttonHtml;
                }
            }
        ],
        order: [[1, 'desc']], // Ordenar por fecha descendente por defecto
        pageLength: 25,
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json'
        },
        dom: '<"top"Bf>rt<"bottom"lip>',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'techwave_fn_button small',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5]
                }
            }
        ],
        responsive: true
    });
    
    // Botón de sincronización
    $('#btnSincronizar').on('click', function() {
        const btn = $(this);
        btn.prop('disabled', true);
        btn.html('<span><i class="fas fa-spinner fa-spin"></i> Sincronizando...</span>');
        
        $.ajax({
            url: '<?= base_url('mercadolibre_orders/sincronizarOrdenes') ?>',
            method: 'POST',
            success: function(response) {
                if (response.success) {
                    $('#statusModalBody').html(`
                        <div class="alert alert-success">
                            <p>${response.message}</p>
                            <ul>
                                <li>Total órdenes sincronizadas: ${response.total_ordenes}</li>
                                <li>Nuevas órdenes: ${response.nuevas_ordenes}</li>
                                <li>Órdenes actualizadas: ${response.ordenes_actualizadas}</li>
                            </ul>
                        </div>
                    `);
                } else {
                    $('#statusModalBody').html(`
                        <div class="alert alert-danger">
                            <p>${response.message}</p>
                        </div>
                    `);
                }
                
                $('#statusModal').modal('show');
                table.ajax.reload();
                
                btn.prop('disabled', false);
                btn.html('<span>Sincronizar Órdenes</span>');
            },
            error: function(xhr) {
                $('#statusModalBody').html(`
                    <div class="alert alert-danger">
                        <p>Error en la sincronización</p>
                    </div>
                `);
                
                $('#statusModal').modal('show');
                
                btn.prop('disabled', false);
                btn.html('<span>Sincronizar Órdenes</span>');
            }
        });
    });
    
    // Botón de crear factura
    $('#tblOrdenes').on('click', '.btn-crear-factura', function() {
    const btn = $(this);
    const orderId = btn.data('order-id');
    
    btn.prop('disabled', true);
    btn.html('<span><i class="fas fa-spinner fa-spin"></i> Procesando...</span>');
    
    $.ajax({
        url: '<?= base_url('mercadolibre_orders/crearFactura') ?>',
        method: 'POST',
        data: {
            order_id: orderId
        },
        success: function(response) {
            console.log('response crear');
            console.log(response);
            if (response.success) {
                Swal.fire({
                    title: 'Factura Creada',
                    html: `
                        <div class="text-left">
                            <p>${response.message}</p>
                            <p>Factura generada: ${response.invoice_id}</p>
                        </div>
                    `,
                    icon: 'success',
                    confirmButtonText: 'Cerrar'
                });
            } else {
                Swal.fire({
                    title: 'Error',
                    text: response.message,
                    icon: 'error',
                    confirmButtonText: 'Cerrar'
                });
            }
            
            table.ajax.reload();
        },
        error: function(xhr) {
            Swal.fire({
                title: 'Error',
                text: 'Error al crear la factura',
                icon: 'error',
                confirmButtonText: 'Cerrar'
            });
            
            btn.prop('disabled', false);
            btn.html('<span>Crear Factura</span>');
        }
    });
});
    // $('#tblOrdenes').on('click', '.btn-crear-factura', function() {
    //     const btn = $(this);
    //     const orderId = btn.data('order-id');
    //     console.log('sasdsadsa');
        
    //     btn.prop('disabled', true);
    //     btn.html('<span><i class="fas fa-spinner fa-spin"></i> Procesando...</span>');
        
    //     $.ajax({
    //         url: '<?= base_url('mercadolibre_orders/crearFactura') ?>',
    //         method: 'POST',
    //         data: {
    //             order_id: orderId
    //         },
    //         success: function(response) {
    //             if (response.success) {
    //                 $('#statusModalBody').html(`
    //                     <div class="alert alert-success">
    //                         <p>${response.message}</p>
    //                         <p>Factura generada: ${response.invoice_id}</p>
    //                     </div>
    //                 `);
    //             } else {
    //                 $('#statusModalBody').html(`
    //                     <div class="alert alert-danger">
    //                         <p>${response.message}</p>
    //                     </div>
    //                 `);
    //             }
                
    //             $('#statusModal').modal('show');
    //             table.ajax.reload();
    //         },
    //         error: function(xhr) {
    //             $('#statusModalBody').html(`
    //                 <div class="alert alert-danger">
    //                     <p>Error al crear la factura</p>
    //                 </div>
    //             `);
                
    //             $('#statusModal').modal('show');
    //             btn.prop('disabled', false);
    //             btn.html('<span>Crear Factura</span>');
    //         }
    //     });
    // });
});
</script>
<?= $this->endSection() ?>